/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <algorithm>
#include <cstdlib>
#include <sstream>

#include "CalibrationGetRawCoordinateCommand.h"
#include "ICommandExecutor.h"
#include "TouchAreaSubdivision.h"

using namespace LayerManagerCalibration;
using namespace std;

ExecutionResult CalibrationGetRawCoordinateCommand::execute(ICommandExecutor* execute)
{
    ExecutionResult result = ExecutionFailed;

    // get device configuration
    InputDeviceConfigurationMap::iterator match =
        execute->getInputDeviceConfigurations()->find(string(m_deviceName));
    if (match != execute->getInputDeviceConfigurations()->end())
    {
        InputDeviceConfiguration* config = match->second;
        uint width, height;
        execute->getResolution(&width, &height);

        if (config->getRawCoordinate(m_subdivisionName,
                                     *m_logical,
                                     *m_raw,
                                     width,
                                     height,
                                     true))
        {
            result = ExecutionSuccess;
        }
    }

    return result;
}

const string CalibrationGetRawCoordinateCommand::getString()
{
    stringstream description;
    description << "CalibrationGetRawCoordinateCommand("
                << "deviceName=" << m_deviceName
                << "subdivisionName=" << m_subdivisionName
                << "logical=(" << m_logical->x << "," << m_logical->y << ")"
                << "raw=(" << m_raw->x << "," << m_raw->y << ")"
                << ")";
    return description.str();
}
